/*
 * Decompiled with CFR 0.152.
 */
package ibm.nways.jdm.database.jdbc;

import ibm.nways.jdm.database.DatabaseEvent;
import ibm.nways.jdm.database.DatabaseListener;
import ibm.nways.jdm.database.DbAttributeSet;
import ibm.nways.jdm.database.DbAuthority;
import ibm.nways.jdm.database.DbConnectionID;
import ibm.nways.jdm.database.DbConnectionKey;
import ibm.nways.jdm.database.DbCriteria;
import ibm.nways.jdm.database.DbObjectID;
import ibm.nways.jdm.database.DbObjectKey;
import ibm.nways.jdm.database.DbResultsHandler;
import ibm.nways.jdm.database.DbSearch;
import ibm.nways.jdm.database.jdbc.DbJdbcAuthority;
import ibm.nways.jdm.database.jdbc.DbJdbcColumn;
import ibm.nways.jdm.database.jdbc.DbJdbcColumnSet;
import ibm.nways.jdm.database.jdbc.DbJdbcConnectionID;
import ibm.nways.jdm.database.jdbc.DbJdbcConnectionKey;
import ibm.nways.jdm.database.jdbc.DbJdbcCriteria;
import ibm.nways.jdm.database.jdbc.DbJdbcDriver;
import ibm.nways.jdm.database.jdbc.DbJdbcNotifier;
import ibm.nways.jdm.database.jdbc.DbJdbcResultsFormatter;
import ibm.nways.jdm.database.jdbc.DbJdbcResultsHandler;
import ibm.nways.jdm.database.jdbc.DbJdbcRowSet;
import ibm.nways.jdm.database.jdbc.DbJdbcSearch;
import ibm.nways.jdm.database.jdbc.DbJdbcTableID;
import ibm.nways.jdm.database.jdbc.DbJdbcTableKey;
import ibm.nways.jdm.database.jdbc.DbJdbcWorker;
import ibm.nways.jdm.database.jdbc.IDbJdbcConnection;
import java.io.Serializable;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Enumeration;
import java.util.Vector;

public class DbJdbcConnection
implements IDbJdbcConnection,
Serializable {
    private static final int TESTING_MULTIPLE_INSERT = 4;
    private static final int TESTING_SINGLE_INSERT = 5;
    protected String driverName;
    protected DbJdbcConnectionID cid = new DbJdbcConnectionID("");
    protected DbJdbcAuthority authority;
    protected DbJdbcConnectionKey key;
    protected int multipleInsert = 1;
    protected transient Connection connection;
    protected transient Vector workVector;
    protected transient Vector notifyVector;
    protected transient DbJdbcWorker worker;
    protected transient DbJdbcNotifier notifier;
    protected transient DatabaseMetaData dbMetaData;
    protected transient DbJdbcDriver driver;

    public DbJdbcConnection() {
        this.initializeWork();
    }

    public DbJdbcConnection(String string) throws ClassNotFoundException, IllegalAccessException, InstantiationException {
        this.setDriver(string);
        this.initializeWork();
    }

    public int getMaxSqlLength() throws SQLException {
        int n = 0;
        if (this.dbMetaData != null) {
            n = this.dbMetaData.getMaxStatementLength() / 2;
        }
        return n;
    }

    public String getDatabaseProductName() throws SQLException {
        String string = null;
        if (this.dbMetaData != null) {
            string = this.dbMetaData.getDatabaseProductName();
        }
        return string;
    }

    public Connection getConnection() {
        return this.connection;
    }

    public DbJdbcConnectionKey getKey() {
        return this.key;
    }

    public String getDriverName() {
        return this.driverName;
    }

    public void setDriver(String string) throws ClassNotFoundException, IllegalAccessException, InstantiationException {
        this.driverName = string;
        this.driver = new DbJdbcDriver(string);
    }

    public DbJdbcConnectionID getConnectionID() {
        return this.cid;
    }

    public int getMultipleInsert() {
        return this.multipleInsert;
    }

    public DbConnectionKey connect(DbConnectionID dbConnectionID, DbAuthority dbAuthority) throws SQLException {
        return this.connectToDatabase((DbJdbcConnectionID)dbConnectionID, (DbJdbcAuthority)dbAuthority);
    }

    public DbJdbcConnectionKey connectToDatabase(DbJdbcConnectionID dbJdbcConnectionID, DbJdbcAuthority dbJdbcAuthority) throws SQLException {
        if (dbJdbcConnectionID == null) {
            throw new IllegalArgumentException();
        }
        this.cid = dbJdbcConnectionID;
        this.authority = dbJdbcAuthority;
        this.initializeWork();
        if (this.worker == null) {
            this.worker = new DbJdbcWorker(this);
            this.worker.start();
        }
        this.connection = dbJdbcAuthority == null ? DriverManager.getConnection(dbJdbcConnectionID.getURL()) : DriverManager.getConnection(dbJdbcConnectionID.getURL(), dbJdbcAuthority.getUser(), dbJdbcAuthority.getPassword());
        try {
            this.dbMetaData = this.connection.getMetaData();
        }
        catch (SQLException sQLException) {}
        this.key = new DbJdbcConnectionKey();
        return this.key;
    }

    public DbJdbcConnectionKey connectToDatabase(String string, DbJdbcAuthority dbJdbcAuthority) throws SQLException {
        return this.connectToDatabase(new DbJdbcConnectionID(string), dbJdbcAuthority);
    }

    public void disconnect() {
        if (this.workVector != null) {
            DatabaseEvent databaseEvent = new DatabaseEvent(this, null);
            databaseEvent.setShutdown(true);
            this.insertDatabaseWork(databaseEvent);
        }
        try {
            this.connection.close();
            return;
        }
        catch (SQLException sQLException) {
            sQLException.printStackTrace();
            return;
        }
    }

    public boolean objectExists(DbObjectID dbObjectID) {
        return this.tableExists((DbJdbcTableID)dbObjectID);
    }

    public boolean tableExists(DbJdbcTableID dbJdbcTableID) {
        boolean bl = false;
        StringBuffer stringBuffer = new StringBuffer().append("SELECT * FROM ").append(dbJdbcTableID.getTableName());
        try {
            this.executeSqlCommand(stringBuffer.toString());
            bl = true;
        }
        catch (SQLException sQLException) {}
        return bl;
    }

    public DbObjectKey createObject(DbObjectID dbObjectID, DbAttributeSet dbAttributeSet) throws SQLException {
        return this.createTable((DbJdbcTableID)dbObjectID, (DbJdbcColumnSet)dbAttributeSet);
    }

    public DbJdbcTableKey createTable(DbJdbcTableID dbJdbcTableID, DbJdbcColumnSet dbJdbcColumnSet) throws SQLException {
        StringBuffer stringBuffer = new StringBuffer().append("CREATE TABLE ").append(dbJdbcTableID.getTableName()).append(" (");
        DbJdbcColumn dbJdbcColumn = null;
        Enumeration enumeration = dbJdbcColumnSet.getColumns();
        boolean bl = true;
        while (enumeration.hasMoreElements()) {
            if (!bl) {
                stringBuffer.append(", ");
            } else {
                bl = false;
            }
            dbJdbcColumn = (DbJdbcColumn)enumeration.nextElement();
            stringBuffer.append(dbJdbcColumn.getNameTypeString());
        }
        stringBuffer.append(")");
        this.executeSqlCommand(stringBuffer.toString());
        return new DbJdbcTableKey();
    }

    public void deleteObject(DbObjectID dbObjectID) throws SQLException {
        this.deleteTable((DbJdbcTableID)dbObjectID);
    }

    public void deleteTable(DbJdbcTableID dbJdbcTableID) throws SQLException {
        StringBuffer stringBuffer = new StringBuffer().append("DROP TABLE ").append(dbJdbcTableID.getTableName());
        this.executeSqlCommand(stringBuffer.toString());
    }

    public void createInstance(DbObjectID dbObjectID, DbAttributeSet dbAttributeSet) throws SQLException {
        this.createRow((DbJdbcTableID)dbObjectID, (DbJdbcColumnSet)dbAttributeSet);
    }

    public void createRow(DbJdbcTableID dbJdbcTableID, DbJdbcColumnSet dbJdbcColumnSet) throws SQLException {
        this.createRows(dbJdbcTableID, dbJdbcColumnSet, dbJdbcColumnSet.getNumberOfColumns());
    }

    public void createRows(DbJdbcTableID dbJdbcTableID, DbJdbcColumnSet dbJdbcColumnSet, int n) throws SQLException {
        StringBuffer stringBuffer = new StringBuffer().append("INSERT INTO ").append(dbJdbcTableID.getTableName()).append(" (");
        StringBuffer stringBuffer2 = new StringBuffer().append("VALUES (");
        StringBuffer stringBuffer3 = null;
        DbJdbcColumn dbJdbcColumn = null;
        int n2 = this.getMaxSqlLength();
        int n3 = 0;
        try {
            Enumeration enumeration = dbJdbcColumnSet.getColumns();
            int n4 = 0;
            while (n4 < dbJdbcColumnSet.getNumberOfColumns()) {
                String string;
                dbJdbcColumn = (DbJdbcColumn)enumeration.nextElement();
                if (n4 < n) {
                    if (n4 % n != 0) {
                        stringBuffer.append(", ");
                    }
                    stringBuffer.append(dbJdbcColumn.getName());
                    if (n4 == n - 1) {
                        stringBuffer.append(") ");
                    }
                }
                if (n4 % n == 0) {
                    if (n4 > 0) {
                        if (this.multipleInsert == 3 || this.multipleInsert == 5 || n2 == 0 || stringBuffer.length() + stringBuffer2.length() + stringBuffer3.length() + 1 > n2) {
                            stringBuffer2.append(")");
                            string = String.valueOf(stringBuffer.toString()) + stringBuffer2.toString();
                            if (this.multipleInsert == 4 || this.multipleInsert == 5) {
                                this.executeSqlCommand(string);
                            } else {
                                this.insertDatabaseWork(string);
                            }
                            stringBuffer2 = new StringBuffer().append("VALUES (");
                            n3 = 0;
                            if (this.multipleInsert == 4) {
                                this.multipleInsert = 2;
                            } else if (this.multipleInsert == 5) {
                                this.multipleInsert = 3;
                            }
                        }
                        if (n3 > 0) {
                            if (this.multipleInsert == 1) {
                                this.multipleInsert = 4;
                            }
                            stringBuffer2.append("),(");
                        }
                        stringBuffer2.append((Object)stringBuffer3);
                        ++n3;
                    }
                    stringBuffer3 = new StringBuffer();
                } else {
                    stringBuffer3.append(", ");
                }
                stringBuffer3.append(dbJdbcColumn.getValueString());
                if (n4 == dbJdbcColumnSet.getNumberOfColumns() - 1) {
                    stringBuffer2.append(stringBuffer3.toString());
                    stringBuffer2.append(")");
                    string = String.valueOf(stringBuffer.toString()) + stringBuffer2.toString();
                    if (this.multipleInsert == 4) {
                        this.executeSqlCommand(string);
                    } else {
                        this.insertDatabaseWork(string);
                    }
                }
                ++n4;
            }
            return;
        }
        catch (SQLException sQLException) {
            if (this.multipleInsert == 4) {
                this.multipleInsert = 5;
                try {
                    this.createRows(dbJdbcTableID, dbJdbcColumnSet, n);
                    return;
                }
                catch (SQLException sQLException2) {
                    this.multipleInsert = 1;
                    throw sQLException2;
                }
            }
            throw sQLException;
        }
    }

    public void deleteInstances(DbObjectID dbObjectID, DbCriteria dbCriteria) {
        this.deleteRows((DbJdbcTableID)dbObjectID, (DbJdbcCriteria)dbCriteria);
    }

    public void deleteRows(DbJdbcTableID dbJdbcTableID, DbJdbcCriteria dbJdbcCriteria) {
        StringBuffer stringBuffer = new StringBuffer().append("DELETE FROM ").append(dbJdbcTableID.getTableName());
        if (dbJdbcCriteria != null) {
            stringBuffer.append(" ").append(dbJdbcCriteria.toString());
        }
        this.insertDatabaseWork(stringBuffer.toString());
    }

    public void modifyInstances(DbObjectID dbObjectID, DbAttributeSet dbAttributeSet, DbCriteria dbCriteria) {
        this.modifyRows((DbJdbcTableID)dbObjectID, (DbJdbcColumnSet)dbAttributeSet, (DbJdbcCriteria)dbCriteria);
    }

    public void modifyRows(DbJdbcTableID dbJdbcTableID, DbJdbcColumnSet dbJdbcColumnSet, DbJdbcCriteria dbJdbcCriteria) {
        StringBuffer stringBuffer = new StringBuffer().append("UPDATE ").append(dbJdbcTableID.getTableName()).append(" SET ");
        DbJdbcColumn dbJdbcColumn = null;
        Enumeration enumeration = dbJdbcColumnSet.getColumns();
        boolean bl = true;
        while (enumeration.hasMoreElements()) {
            if (!bl) {
                stringBuffer.append(", ");
            } else {
                bl = false;
            }
            dbJdbcColumn = (DbJdbcColumn)enumeration.nextElement();
            stringBuffer.append(dbJdbcColumn.getColumnName()).append(" = ").append(dbJdbcColumn.getValueString());
        }
        if (dbJdbcCriteria != null) {
            stringBuffer.append(" ").append(dbJdbcCriteria.toString());
        }
        this.insertDatabaseWork(stringBuffer.toString());
    }

    public Object getInstances(DbSearch dbSearch) throws SQLException {
        return this.getRows((DbJdbcSearch)dbSearch);
    }

    public DbJdbcRowSet getRows(DbJdbcSearch dbJdbcSearch) throws SQLException {
        return this.executeSqlQuery(dbJdbcSearch.toString());
    }

    public void getInstances(DbSearch dbSearch, DbResultsHandler dbResultsHandler) throws SQLException {
        this.getRows((DbJdbcSearch)dbSearch, (DbJdbcResultsHandler)dbResultsHandler);
    }

    public void getRows(DbJdbcSearch dbJdbcSearch, DbJdbcResultsHandler dbJdbcResultsHandler) throws SQLException {
        this.handleSqlSearch(dbJdbcSearch, dbJdbcResultsHandler);
    }

    private Connection checkConnection() throws SQLException {
        if (this.driver == null) {
            try {
                this.setDriver(this.driverName);
            }
            catch (Exception exception) {
                throw new SQLException();
            }
        }
        if (this.connection == null) {
            this.connectToDatabase(this.cid, this.authority);
        }
        return this.connection;
    }

    private synchronized void handleSqlSearch(DbJdbcSearch dbJdbcSearch, DbJdbcResultsHandler dbJdbcResultsHandler) throws SQLException {
        Statement statement = this.checkConnection().createStatement();
        ResultSet resultSet = statement.executeQuery(dbJdbcSearch.toString());
        DbJdbcResultsFormatter dbJdbcResultsFormatter = dbJdbcResultsHandler.getJdbcResultsFormatter();
        if (dbJdbcResultsFormatter != null) {
            dbJdbcResultsHandler.handleJdbcResults(this, dbJdbcSearch, dbJdbcResultsFormatter.formatJdbcResults(resultSet));
        } else {
            dbJdbcResultsHandler.handleJdbcResults(this, dbJdbcSearch, new DbJdbcRowSet(resultSet));
        }
        statement.close();
    }

    private synchronized DbJdbcRowSet executeSqlQuery(String string) throws SQLException {
        Statement statement = this.checkConnection().createStatement();
        ResultSet resultSet = statement.executeQuery(string);
        DbJdbcRowSet dbJdbcRowSet = new DbJdbcRowSet(resultSet);
        statement.close();
        return dbJdbcRowSet;
    }

    private synchronized void executeSqlCommand(String string) throws SQLException {
        Statement statement = this.checkConnection().createStatement();
        statement.execute(string);
        statement.close();
    }

    private synchronized void initializeWork() {
        this.workVector = new Vector();
        this.notifyVector = new Vector();
    }

    public boolean hasWork() {
        boolean bl = false;
        Vector vector = this.workVector;
        synchronized (vector) {
            if (this.workVector.size() > 0) {
                bl = true;
            }
        }
        return bl;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    DatabaseEvent getNextWork() {
        DatabaseEvent databaseEvent = null;
        Vector vector = this.workVector;
        synchronized (vector) {
            while (true) {
                if (!this.workVector.isEmpty()) {
                    databaseEvent = (DatabaseEvent)this.workVector.firstElement();
                    this.workVector.removeElementAt(0);
                    if (this.workVector.isEmpty()) return databaseEvent;
                    databaseEvent.setMoreWork(true);
                    return databaseEvent;
                }
                try {
                    this.workVector.wait();
                }
                catch (InterruptedException interruptedException) {}
            }
        }
    }

    void notifyComplete(DatabaseEvent databaseEvent) {
        if (this.notifier != null && this.notifier.areThereListeners()) {
            Vector vector = this.notifyVector;
            synchronized (vector) {
                this.notifyVector.addElement(databaseEvent);
                this.notifyVector.notify();
                return;
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    DatabaseEvent getNextNotifyEvent() {
        DatabaseEvent databaseEvent = null;
        Vector vector = this.notifyVector;
        synchronized (vector) {
            while (true) {
                if (!this.notifyVector.isEmpty()) {
                    databaseEvent = (DatabaseEvent)this.notifyVector.firstElement();
                    this.notifyVector.removeElementAt(0);
                    return databaseEvent;
                }
                try {
                    this.notifyVector.wait();
                }
                catch (InterruptedException interruptedException) {}
            }
        }
    }

    public void insertDatabaseWork(String string) {
        Vector vector = this.workVector;
        synchronized (vector) {
            this.workVector.addElement(new DatabaseEvent(this, string));
            this.workVector.notify();
            return;
        }
    }

    public void insertDatabaseWork(DatabaseEvent databaseEvent) {
        Vector vector = this.workVector;
        synchronized (vector) {
            this.workVector.addElement(databaseEvent);
            this.workVector.notify();
            return;
        }
    }

    public void addDatabaseListener(DatabaseListener databaseListener, int n) {
        if (this.notifier == null) {
            this.notifier = new DbJdbcNotifier(this);
        }
        this.notifier.addDatabaseListener(databaseListener, n);
    }

    public void removeDatabaseListener(DatabaseListener databaseListener) {
        this.notifier.removeDatabaseListener(databaseListener);
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        if (this.driver != null) {
            stringBuffer.append(this.driver.toString());
        }
        if (this.cid != null) {
            stringBuffer.append(":").append(this.cid.toString());
        }
        if (this.authority != null) {
            stringBuffer.append(":").append(this.authority.toString());
        }
        return stringBuffer.toString();
    }

    public boolean equals(Object object) {
        boolean bl = false;
        if (object instanceof DbJdbcConnection) {
            DbJdbcConnection dbJdbcConnection = (DbJdbcConnection)object;
            bl = this.getConnectionID().equals(dbJdbcConnection.getConnectionID());
        }
        return bl;
    }

    public int hashCode() {
        return this.getConnectionID().hashCode();
    }

    public void waitForDisconnect() {
        try {
            this.worker.getThread().join();
            return;
        }
        catch (InterruptedException interruptedException) {
            return;
        }
    }
}

